-- add TDP for create enquiry velocity


-- Template data provider for enquiry velocity
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'CREATE_ENQUIRY_VELOCITY_TDP', 'CB');


SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='CREATE_ENQUIRY_VELOCITY_TDP');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,NULL,NULL);


-- For this message category this is the template data provider
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='CREATE_ENQUIRY_VELOCITY_TDP');
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='CREATE_ENQUIRY_VELOCITY');
SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
INSERT INTO `template_dtprovider`(`id`,`msgSubCategoryId`,`dataProviderId`,`dataProviderName`) VALUES (@templatedtproviderId+1,@msgSubCategoryId,@dtproviderId,'CREATE_ENQUIRY_VELOCITY_TDP');



-- Setting data in cb_dtprovider for the CREATE_ENQUIRY_VELOCITY_TDP ADDED
SET @cbdtproviderId=(SELECT MAX(id) FROM `cb_dtprovider`);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='CREATE_ENQUIRY_VELOCITY_TDP');
insert  into `cb_dtprovider`(`id`,`dataProviderId`,`searchConfigCode`,`searchResultViewCode`) values (@cbdtproviderId+1, @dtproviderId,'MSG_CREATE_ENQUIRY_VELOCITY_TEMPLATE_DATA','MSG_CREATE_ENQUIRY_VELOCITY_TEMPLATE_DATA'); 


-- update recipient DL
set sql_safe_updates=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_VELOCITY_RECIPIENTS');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T1.code AS ENQUIRY_CODE,
        T1.firstName AS PARENT_FIRSTNAME,
        T1.lastName AS PARENT_LASTNAME,
        T2.studentFirstName AS STUDENT_FIRSTNAME,
        T2.studentLastName AS STUDENT_LASTNAME,       
        T1.primaryeEmailId AS EMAIL_ID,
        T1.phoneNo AS MOBILE_NO,
        T1.phoneCountryCode AS MOBILE_CODE    	  
    FROM
        enquiry T1
            LEFT JOIN
        enq_student_details T2 ON T2.enquiryId = T1.id
            LEFT JOIN
        admission_enq_details T3 ON T3.enqStudentDetailsId = T2.id       
    WHERE
        T1.id IN (namedParams)
         ',
    `jsonString` = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 1,
                "value": "code",
                "resultKey": "ENQUIRY_CODE",
                "displayCode": "",
                "displayOrder": 0
            },
            {
                "id": 2,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 1
            },
            {
                "id": 3,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "studentFirstName",
                "resultKey": "STUDENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "studentLastName",
                "resultKey": "STUDENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 4
            }
        ]
    }'
WHERE
    `dataProviderId` = @dtproviderId;
    
-- update msg template config for TDP
UPDATE `msg_template_config` SET `templateDataProviderId`=@templatedtproviderId+1 WHERE `templateConfigName`='Create Enquiry Velocity Template';

-- update msg template
SET @msgTemplateId=(SELECT id FROM msg_template_config WHERE `code`='Create Enquiry Velocity Template');

UPDATE `msg_template` SET `msgContent`="<html>
<head>
	<title></title>
</head>
<body>
<p>Lead ID&nbsp;<strong>$recipientData[&quot;ENQUIRY_CODE&quot;]</strong></p>

<p>Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></p>

<p>Thank you for your interest in <strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;joining our ever-growing <strong>$templateData[&quot;ACADEMY_NAME&quot;]</strong>&nbsp;community. We look forward to a long and prosperous relationship with both you and your child. In fact, we have a dedicated team of staff who are ready and waiting to answer any questions you may have.</p>

<p><strong>What&rsquo;s the next step?</strong></p>

<p>If you require more information on our school or require any further assistance, please click here<br />
<strong>$templateData[&quot;ACADEMY_EMAIL&quot;]</strong>&nbsp;and the school will contact you telephonically to discuss.</p>

<p><br />
If you are interested in applying for admission to our school, please click here <strong>$templateData[&quot;WEBSITE_URL&quot;]</strong>&nbsp;to get the process started. Your application will be assessed and, depending on the grade (form or standard) you are enquiring for, an assessment/interview may be scheduled. If the assessment/interview has been successful, you will receive a &ldquo;Conditional Admission&rdquo; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.</p>

<p>We can&rsquo;t wait to hear back from you!</p>

<p>Kind regards,<br />
<strong>$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
</body>
</html>" WHERE `msgTemplateConfigId`=@msgTemplateId and `msgDeliveryModeId` = 1;

UPDATE `msg_template` SET `msgContent`='Dear $recipientData["PARENT_FIRSTNAME"] $recipientData["PARENT_LASTNAME"],
Thank you for your interest in our school. We will be touch shortly. 
$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]' WHERE `msgTemplateConfigId`=@msgTemplateId and `msgDeliveryModeId` = 2;


-- END: create enquiry velocity



-- update for external user msg event

SET @externalUserDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO');


UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T4.`firstName` AS FIRST_NAME,
        T4.`lastName` AS LAST_NAME,
        T6.`emailId` AS EMAIL_ID,
        T6.`mobileNumber` AS MOBILE_NO,
        T6.`mobileCountryCode` AS MOBILE_CODE,
        T6.`firstName` AS PARENT_FIRSTNAME,
        T6.`lastName` AS PARENT_LASTNAME,    
    	T3.`code` as APPLICATION_CODE
    FROM
        external_users T1
            LEFT JOIN
        external_user_association T2 ON T2.externalUserId = T1.id
            LEFT JOIN
        application T3 ON T3.id = T2.applicationId
            LEFT JOIN
        applicant_person T4 ON T4.id = T3.applicantPersonId
            LEFT JOIN
        applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
            LEFT JOIN
        applicant_person T6 ON T6.id = T5.relatedApplicantPersonId  
    WHERE
        T1.id IN (namedParams)
            AND T5.relationship = \'FATHER\'
            ',
    `jsonString` = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            }
        ]
    }'
WHERE
    `dataProviderId` = @externalUserDtproviderId;
    
    
-- update template of external user velocity

SET @templateConfigs=(SELECT id FROM msg_template_config WHERE `code`='Add External User Velocity');

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Application ID&nbsp;<strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Thank you for your interest in applying and submitting your application for <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong>. We have received your application fee and will now proceed with your application.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your application will now be assessed by the school and, depending on the grade (form or standard) you are applying for, there may be an additional assessment/interview. Should this be required, we will contact you&nbsp;telephonically to arrange a suitable time and date and the details will be emailed to you.&nbsp;To access your &ldquo;Application Portal&rdquo;, please use the following login details to monitor your application:</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Username:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Should you have any queries please contact <strong>$templateData[&quot;ACADEMY_EMAILID&quot;]</strong>.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Kind regards,<br />
			$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @templateConfigs and msgDeliveryModeId=1;

UPDATE `msg_template` SET `msgContent`='Dear $recipientData["PARENT_FIRSTNAME"] $recipientData["PARENT_LASTNAME"], Thank you for your application and payment. We will be in touch with more details soon. Regards, $templateData["ACADEMY_NAME_LOCATION"]' WHERE `msgTemplateConfigId`= @templateConfigs and msgDeliveryModeId = 2;


-- update enquiry DL for multiple adhoc msg sent

SET @enquiryDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_ENQUIRER_DL');

UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT T1.id AS USER_ID FROM enquiry T1 where T1.id IN (namedParams) 
         <MSG@ACAD_LOC_CRITERIA> AND T1.academyLocationId IN (msg_scope_acad_loc_Ids)</MSG>'
WHERE
    dataProviderId = @enquiryDtproviderId;


set sql_safe_updates=1;

